/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.fsp.cmdhelpers;

import com.ibm.hsc.common.util.ByteUtilities;
import com.ibm.hsc.common.util.PIParseResponse;
import com.ibm.hsc.fsp.cmdhelpers.CodAsyncMsg;
import java.io.IOException;
import java.util.BitSet;
import java.util.Hashtable;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt8;

public class FspCodAsyncEventData {
    private BitSet mEventMask;
    private UnsignedInt8 mMsgListLength;
    private CodAsyncMsg[] mMsgList;
    private static final String COD_ASYNC_STATE_CHANGE = "COD_ASYNC_STATE_CHANGE";
    private static final String COD_EVT_MASK = "COD_EVT_MASK";
    private static final String MSG_LIST_LENGTH = "MSG_LIST_LENGTH";
    private static final String COD_MSG_LIST = "COD_MSG_LIST";
    private static final String MSG_DESTINATION = "MSG_DESTINATION";
    private static final String MSG_ID = "MSG_ID";
    private static final String MSG_PARM_LIST_LENGTH = "MSG_PARM_LIST_LENGTH";
    private static final String PARM_LIST = "PARM_LIST";
    private static final String MSG_PARM = "MSG_PARM";
    public static final int COD_KEY_PROCESSING_SUCCESS_EVT_BIT = 0;
    public static final int COD_KEY_PROCESSING_FAILURE_EVT_BIT = 1;
    public static final int COD_DISPLAY_MSG_EVT_BIT = 2;
    public static final int COD_ONOFF_PROC_STATE_CHANGE_EVT_BIT = 3;
    public static final int COD_ONOFF_MEM_STATE_CHANGE_EVT_BIT = 4;
    public static final int COD_METERED_PROC_STATE_CHANGE_EVT_BIT = 5;
    public static final int COD_METERED_MEM_STATE_CHANGE_EVT_BIT = 6;
    public static final int COD_TRIAL_PROC_STATE_CHANGE_EVT_BIT = 7;
    public static final int COD_TRIAL_MEM_STATE_CHANGE_EVT_BIT = 8;
    public static final int COD_STATE_CHANGE_EVT_BIT = 9;
    public static final int FOD_KEY_PROCESSING_SUCCESS_EVT_BIT = 12;
    public static final int FOD_KEY_PROCESSING_FAILURE_EVT_BIT = 13;

    public String toString() {
        String string = "eventMask = ";
        String string2 = "msgListLength = ";
        String string3 = "msgList = ";
        if (this.mEventMask != null) {
            string = string + this.mEventMask.toString();
        }
        if (this.mMsgListLength != null) {
            string2 = string2 + this.mMsgListLength.toString();
        }
        if (this.mMsgList != null) {
            for (int i = 0; i < this.mMsgListLength.intValue(); ++i) {
                string3 = string3 + this.mMsgList[i].toString() + " ";
            }
        }
        return string + "; " + string2 + "; " + string3;
    }

    public FspCodAsyncEventData getCodAsyncEventData(PIParseResponse pIParseResponse) throws IOException {
        Hashtable hashtable = pIParseResponse.getParsedData(COD_ASYNC_STATE_CHANGE);
        byte[] byArray = (byte[])hashtable.get(COD_EVT_MASK);
        this.mEventMask = ByteUtilities.byteArrayToBitSet(byArray);
        this.mMsgListLength = (UnsignedInt8)hashtable.get(MSG_LIST_LENGTH);
        this.mMsgList = new CodAsyncMsg[this.mMsgListLength.intValue()];
        Object[] objectArray = (Object[])hashtable.get(COD_MSG_LIST);
        for (int i = 0; i < this.mMsgListLength.intValue(); ++i) {
            CodAsyncMsg codAsyncMsg = new CodAsyncMsg();
            Hashtable hashtable2 = (Hashtable)objectArray[i];
            codAsyncMsg.mDestination = (UnsignedInt16)hashtable2.get(MSG_DESTINATION);
            codAsyncMsg.mMsgId = (UnsignedInt16)hashtable2.get(MSG_ID);
            codAsyncMsg.mParmListLength = (UnsignedInt8)hashtable2.get(MSG_PARM_LIST_LENGTH);
            codAsyncMsg.mParmList = new UnsignedInt16[codAsyncMsg.mParmListLength.intValue()];
            Object[] objectArray2 = (Object[])hashtable2.get(PARM_LIST);
            for (int j = 0; j < objectArray2.length; ++j) {
                Hashtable hashtable3 = (Hashtable)objectArray2[j];
                codAsyncMsg.mParmList[j] = (UnsignedInt16)hashtable3.get(MSG_PARM);
            }
            this.mMsgList[i] = codAsyncMsg;
        }
        return this;
    }

    public BitSet getEventMask() {
        return this.mEventMask;
    }

    public UnsignedInt8 getMsgListLength() {
        return this.mMsgListLength;
    }

    public CodAsyncMsg[] getMsgList() {
        return this.mMsgList;
    }
}

